#include "bullet.h"
#include "global.h"
#include <cmath>
 
bullet::bullet(float X, float Y, float tox, float toy)
{
	x = X;
	y = Y;
	a = getAngle(X, Y, tox, toy) - 64.0f;
	init();
}

bullet::bullet(float X, float Y, float A)
{
	x = X;
	y = Y;
	a = A - 64.0f;
	init();
}

void bullet::draw(BITMAP *to)
{
	if(col)
		putpixel(to, (int)x, (int)y, makecol(255, 255, 255));
	else
		putpixel(to, (int)x, (int)y, makecol(0, 0, 0));
}

void bullet::update()
{
	x = x + timeAdjuster * (v * cos(angToRad(a)));
	y = y + timeAdjuster * (v * sin(angToRad(a)));
}

void bullet::init()
{
	int randVal = rand() % 10000;
	float randFloat = randVal / 20000.0f - 0.25f;
	v = 1.0f + randFloat;
	randVal = rand() % 2;
	if(randVal)
		col = true;
	else
		col = false;
}

